/*
 * @(#)TaskFigure.java  1.0  18. Juni 2006
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.pert.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.pert.model.*;
import ch.hslu.cm.simulation.*;
import java.awt.geom.*;
import java.beans.*;
import java.io.IOException;
import static org.jhotdraw.draw.AttributeKeys.*;
import java.util.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.LocatorConnector;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.handle.ConnectorHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.layouter.VerticalLayouter;
import org.jhotdraw.draw.locator.RelativeLocator;
import org.jhotdraw.geom.*;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/**
 * TaskFigure.
 *
 * @author Werner Randelshofer.
 * @version 1.0 18. Juni 2006 Created.
 */
public class TaskFigure extends GraphicalCompositeFigure
        implements DiagramFigure, PropertyChangeListener, SimulatedObjectListener {
    
    private Task model;
    
    /**
     * This adapter is used, to connect a TextFigure with the name of
     * the Task model.
     */
    private static class NameAdapter extends FigureAdapter {
        private TaskFigure target;
        public NameAdapter(TaskFigure target) {
            this.target = target;
        }
    @Override
        public void attributeChanged(FigureEvent e) {
            if (e.getAttribute().equals(TEXT)) {
                target.model.setName((String) e.getNewValue());
            }
        }
    }
    private static class DurationAdapter extends FigureAdapter {
        private TaskFigure target;
        public DurationAdapter(TaskFigure target) {
            this.target = target;
        }
    @Override
        public void attributeChanged(FigureEvent evt) {
            if (evt.getAttribute().equals(TEXT)) {
                try {
                    target.model.setDuration(Integer.decode((String) evt.getNewValue()));
                } catch (NumberFormatException e) {
                    target.model.setDuration(0);
                }
            }
        }
    }
    
    /** Creates a new instance. */
    public TaskFigure() {
        super(new RectangleFigure());
        
        setLayouter(new VerticalLayouter());
        
        RectangleFigure nameCompartmentPF = new RectangleFigure();
        STROKE_COLOR.set(nameCompartmentPF, null);
        nameCompartmentPF.setAttributeEnabled(STROKE_COLOR, false);
        FILL_COLOR.set(nameCompartmentPF, null);
        nameCompartmentPF.setAttributeEnabled(FILL_COLOR, false);
        ListFigure nameCompartment = new ListFigure(nameCompartmentPF);
        ListFigure attributeCompartment = new ListFigure();
        SeparatorLineFigure separator1 = new SeparatorLineFigure();
        
        applyAttributes(getPresentationFigure());
        
        add(nameCompartment);
        add(separator1);
        add(attributeCompartment);
        
        Insets2D.Double insets = new Insets2D.Double(4,8,4,8);
        LAYOUT_INSETS.set(nameCompartment, insets);
        LAYOUT_INSETS.set(attributeCompartment, insets);
        
        TextFigure nameFigure;
        nameCompartment.add(nameFigure = new TextFigure());
        nameFigure.addFigureListener(new NameAdapter(this));
        FONT_BOLD.set(nameFigure, true);
        nameFigure.setAttributeEnabled(FONT_BOLD, false);
        
        TextFigure durationFigure;
        attributeCompartment.add(durationFigure = new TextFigure());
        durationFigure.addFigureListener(new DurationAdapter(this));
        FONT_BOLD.set(durationFigure, true);
        nameFigure.setAttributeEnabled(FONT_BOLD, false);
        
        TextFigure startTimeFigure;
        attributeCompartment.add(startTimeFigure = new TextFigure());
        startTimeFigure.setEditable(false);
        nameFigure.setAttributeEnabled(FONT_BOLD, false);
        
        applyAttributes(this);
        setModel(createPertTask());
        
        setAttributeEnabled(STROKE_DASHES, false);
    }
    
    
    protected Task createPertTask() {
        return new Task();
    }
    
    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        List<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeLocator.southWest()));
            handles.add(new MoveHandle(this, RelativeLocator.southEast()));
            handles.add(new ConnectorHandle(new LocatorConnector(this, RelativeLocator.east()), new DependencyFigure()));
        }
        return handles;
    }
    
    public void setModel(Task m) {
        willChange();
        if (model != null) {
            model.removePropertyChangeListener(this);
        }
        model = m;
        if (model != null) {
            model.addPropertyChangeListener(this);
            updateFigures();
        }
        layout();
        changed();
    }
    
    @Override
    public Task getModel() {
        return model;
    }
    
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return getDiagram().getSimulation();
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if ((drawing instanceof Diagram) && getModel() != null) {
            getSimulation().add(getModel());
        }
    }
    @Override
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }

    private void updateFigures() {
        getNameFigure().setText(model.getName());
        getDurationFigure().setText(Integer.toString(model.getDuration()));
        getStartTimeFigure().setText(Integer.toString(model.getStartTime()));
    }
    
    private TextFigure getNameFigure() {
        return (TextFigure) ((ListFigure) getChild(0)).getChild(0);
    }
    private TextFigure getDurationFigure() {
        return (TextFigure) ((ListFigure) getChild(2)).getChild(0);
    }
    private TextFigure getStartTimeFigure() {
        return (TextFigure) ((ListFigure) getChild(2)).getChild(1);
    }
    
    private void applyAttributes(Figure f) {
        Map<AttributeKey,Object> attr = ((AbstractAttributedFigure) getPresentationFigure()).getAttributes();
        for (Map.Entry<AttributeKey, Object> entry : attr.entrySet()) {
            f.set(entry.getKey(), entry.getValue());
        }
    }
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name == "startTime") {
            getStartTimeFigure().setText(evt.getNewValue()+"");
        }
    }
    @Override
    public TaskFigure clone() {
        TaskFigure that = (TaskFigure) super.clone();
        that.setModel((Task) this.model.clone());
        that.getNameFigure().addFigureListener(new NameAdapter(that));
        that.getDurationFigure().addFigureListener(new DurationAdapter(that));
        
        return that;
    }
    @Override
    public void read(DOMInput in) throws IOException {
        double x = in.getAttribute("x", 0d);
        double y = in.getAttribute("y", 0d);
        double w = in.getAttribute("w", 0d);
        double h = in.getAttribute("h", 0d);
        setBounds(new Point2D.Double(x,y), new Point2D.Double(x+w,y+h));
        readAttributes(in);
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((Task) in.readObject(0));
        in.closeElement();
    }
    @Override
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        writeAttributes(out);
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
    }
    @Override
    public int getLayer() {
        return PertDiagram.TASK_LAYER;
    }
    
    @Override
    public void relationshipAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void relationshipRemoved(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectChanged(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectRemoved(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectRequestRemove(SimulatedObjectEvent e) {
        fireFigureRequestRemove();
    }
}

